﻿Public Class Favorites
    Implements IDisposable

    Private disposedValue As Boolean = False        ' To detect redundant calls

    ' IDisposable
    Protected Overridable Sub Dispose(ByVal disposing As Boolean)
        If Not Me.disposedValue Then
            If disposing Then
                ' TODO: free other state (managed objects).
            End If

            ' TODO: free your own state (unmanaged objects).
            ' TODO: set large fields to null.
        End If
        Me.disposedValue = True
    End Sub

#Region " IDisposable Support "
    ' This code added by Visual Basic to correctly implement the disposable pattern.
    Public Sub Dispose() Implements IDisposable.Dispose
        ' Do not change this code.  Put cleanup code in Dispose(ByVal disposing As Boolean) above.
        Dispose(True)
        GC.SuppressFinalize(Me)
    End Sub
#End Region

    'Składowa publiczna.
    Public FavoritesCollection As WebFavoriteCollection

    Public ReadOnly Property FavoritesFolder() As String
        Get
            'Zwracanie ścieżki do katalogu Ulubione użytkownika.
            Return Environment.GetFolderPath( _
                Environment.SpecialFolder.Favorites)
        End Get
    End Property

    Public Sub ScanFavorites()
        'Przeglądanie katalogu Ulubione.
        ScanFavorites(FavoritesFolder)
    End Sub

    Public Sub ScanFavorites(ByVal folderName As String)
        'Jeśli nie utworzono egzemplarza zmiennej składowej FavoritesCollection,
        'należy to zrobić.
        If FavoritesCollection Is Nothing Then
            FavoritesCollection = New WebFavoriteCollection
        End If

        'Przetwarzanie kolejnych plików katalogu Ulubione.
        For Each strFile As String In _
            My.Computer.FileSystem.GetFiles(folderName)

            'Jeśli plik ma rozszerzenie .url…
            If strFile.EndsWith(".url", True, Nothing) Then

                Try
                    'Tworzenie i używanie nowego egzemplarza 
                    'klasy WebFavorite.
                    Using objWebFavorite As New WebFavorite
                        'Ładowanie informacji o pliku.
                        objWebFavorite.Load(strFile)

                        'Dodawanie obiektu do kolekcji.
                        FavoritesCollection.Add(objWebFavorite)
                    End Using
                Catch ExceptionErr As Exception
                    'Zwracanie wyjątku do jednostki wywołującej.
                    Throw New Exception(ExceptionErr.Message)
                End Try

            End If

        Next
    End Sub

End Class
